# SmartCashBackEvo - Инструкция по установке на Windows

Подробное руководство по установке SmartCashBackEvo как Windows Service.

## 📑 Содержание

1. [Требования](#требования)
2. [Быстрая установка](#быстрая-установка)
3. [Подробная установка](#подробная-установка)
4. [Настройка SSL](#настройка-ssl)
5. [Конфигурация](#конфигурация)
6. [Первый запуск](#первый-запуск)
7. [Решение проблем](#решение-проблем)
8. [Обновление](#обновление)
9. [Удаление](#удаление)

---

## Требования

### Система:

- **ОС**: Windows Server 2016+ или Windows 10/11 Pro
- **RAM**: 2+ GB (рекомендуется 4+ GB)
- **Диск**: 500 MB свободного места
- **Порты**: 5000 (HTTP), 5001 (HTTPS) - настраиваемые
- **Права**: Администратор

### Дополнительно:

- .NET Runtime 8.0 (включен в self-contained дистрибутив)
- PowerShell 5.1+ (входит в Windows)

---

## Быстрая установка

### ⚠️ ВАЖНО: Перед началом установки!

Скрипты PowerShell по умолчанию могут быть заблокированы политикой выполнения.
Скрипт установки **автоматически** предложит разрешить выполнение скриптов при необходимости.

Или выполните вручную:
```powershell
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned -Scope CurrentUser
```

### Установка с параметрами по умолчанию:

```powershell
# 1. Распакуйте архив в удобное место
Expand-Archive -Path "SmartCashBackEvo_Distribution_*.zip" -DestinationPath "C:\Temp\"

# 2. Запустите PowerShell от имени Администратора
# Win + X → Windows PowerShell (Администратор)

# 3. Перейдите в папку скриптов
cd C:\Temp\Distribution\Deployment

# 4. Установите сервис (скрипт предложит настроить SSL автоматически)
.\install-service.ps1

# Скрипт автоматически:
# - Проверит права администратора
# - Проверит и настроит PowerShell execution policy
# - Создаст все необходимые папки
# - Скопирует файлы приложения
# - Создаст директорию для ключей подписи (будут сгенерированы при первом запуске)
# - Предложит создать SSL сертификат
# - Настроит права доступа
# - Настроит Windows Service
# - Настроит файрвол
# - Предложит запустить сервис

# 5. Откройте браузер
Start-Process "https://localhost:5001"
```

**Готово!** ✅

### 🔐 Важная информация о безопасности

- **Ключи подписи Identity Server**: Автоматически генерируются на сервере при первом запуске приложения. Ключи разработчика НЕ копируются в дистрибутив.
- **SSL сертификат**: Можно создать автоматически во время установки или настроить позже.
- **Права доступа**: Автоматически настраиваются для всех необходимых папок.

---

## Подробная установка

### Шаг 1: Распаковка архива

```powershell
# Распаковать в удобное место
Expand-Archive -Path "C:\Downloads\SmartCashBackEvo_Distribution_*.zip" -DestinationPath "C:\Temp\"

# Проверить содержимое
Get-ChildItem C:\Temp\Distribution\
```

**Структура:**
```
Distribution/
├── app/                    # Файлы приложения
├── Deployment/             # Скрипты установки
├── INSTALL-RU.md          # Этот файл
└── README-RU.md           # Краткое руководство
```

### Шаг 2: Запуск PowerShell от имени Администратора

1. Нажмите **Win + X**
2. Выберите **Windows PowerShell (Администратор)**
3. В UAC диалоге нажмите **Да**

Проверка прав:
```powershell
# Должен вывести: Administrator
[Security.Principal.WindowsIdentity]::GetCurrent().Name
```

### Шаг 3: Установка сервиса

```powershell
# Перейти в папку скриптов
cd C:\Temp\Distribution\Deployment

# Установить с параметрами по умолчанию
.\install-service-ru.ps1

# Или с custom параметрами
.\install-service-ru.ps1 `
    -InstallPath "D:\Apps\SmartCashBackEvo" `
    -HttpPort 8000 `
    -HttpsPort 8001 `
    -StartService
```

**Параметры:**

| Параметр | По умолчанию | Описание |
|----------|--------------|----------|
| `-InstallPath` | `C:\SmartCashBackEvo` | Папка установки |
| `-ServiceName` | `SmartCashBackEvo` | Имя сервиса |
| `-DisplayName` | `Smart CashBack Evo Service` | Отображаемое имя |
| `-HttpPort` | `5000` | HTTP порт |
| `-HttpsPort` | `5001` | HTTPS порт |
| `-StartService` | `false` | Запустить сразу |

**Что происходит при установке:**

1. ✅ Создается папка установки
2. ✅ Копируются файлы приложения
3. ✅ Создаются папки data и logs
4. ✅ Создается Windows Service
5. ✅ Настраивается автозапуск при загрузке
6. ✅ Настраиваются права доступа
7. ✅ Создается шаблон конфигурации

### Шаг 4: Проверка установки

```powershell
# Проверить статус сервиса
Get-Service SmartCashBackEvo

# Должен показать:
# Status   : Stopped (или Running если -StartService)
# StartType: Automatic
```

---

## Настройка SSL

SSL сертификат необходим для безопасной работы через HTTPS.

### Вариант 1: Автогенерация (рекомендуется для тестирования)

```powershell
.\setup-ssl-ru.ps1

# В меню выбрать: 1

# Вопросы:
# - Домен: localhost (Enter для умолчания)
# - Пароль: Enter для пустого пароля
```

**Преимущества:**
- ✅ Быстро и просто
- ✅ Работает сразу на локальной машине
- ✅ Автоматически добавляется в доверенные
- ✅ Срок действия 10 лет

**Ограничения:**
- ⚠️ Предупреждения в браузере на других машинах
- ⚠️ Не подходит для публичных сайтов

### Вариант 2: Свой сертификат (рекомендуется для продакшена)

```powershell
.\setup-ssl-ru.ps1

# В меню выбрать: 2

# Вопросы:
# - Путь к .pfx файлу: C:\Certs\mycert.pfx
# - Пароль: [ввести пароль сертификата]
```

**Где получить сертификат:**

#### Let's Encrypt (бесплатно):
1. Установите **Certify The Web**: https://certifytheweb.com
2. Укажите домен и настройте валидацию (HTTP-01 или DNS-01)
3. Получите и экспортируйте сертификат в .pfx

#### Коммерческие CA:
- DigiCert, Sectigo, GlobalSign и др.
- Покупка сертификата → получение .pfx файла

#### Корпоративный PKI:
- Если в организации есть PKI
- Запросить сертификат у администратора

### Вариант 3: Без SSL (не рекомендуется)

```powershell
.\setup-ssl-ru.ps1

# В меню выбрать: 3
```

⚠️ **Внимание:** Работа только по HTTP. Используйте только если:
- Тестирование на локальной машине
- За приложением стоит reverse proxy с SSL
- Внутренняя сеть с другими мерами безопасности

### Проверка SSL

```powershell
# Запустить/перезапустить сервис
Start-Service SmartCashBackEvo

# Проверить доступ
Invoke-WebRequest https://localhost:5001/health

# Открыть в браузере
Start-Process "https://localhost:5001"
```

---

## Конфигурация

### Через интерактивное меню

```powershell
.\configure-ru.ps1
```

**Доступные опции:**

1. **Изменить порты HTTP/HTTPS**
   - Если порты 5000/5001 заняты
   - Автоматически обновляет файрвол

2. **Изменить URL клиента**
   - Для доступа по доменному имени
   - Например: `https://cashback.example.com`

3. **Настроить уровень логирования**
   - Изменить детальность логов
   - Уровни: Trace, Debug, Information, Warning, Error

4. **Просмотреть конфигурацию**
   - Показать текущие настройки

5. **Редактировать JSON вручную**
   - Открыть в Блокноте

### Ручное редактирование

```powershell
# Открыть конфигурацию
notepad C:\SmartCashBackEvo\app\appsettings.Production.json
```

**Основные параметры:**

```json
{
  "ClientUrl": "https://localhost:5001",
  "Kestrel": {
    "Endpoints": {
      "Http": {
        "Url": "http://localhost:5000"
      },
      "Https": {
        "Url": "https://localhost:5001",
        "Certificate": {
          "Path": "C:\\SmartCashBackEvo\\certificate.pfx",
          "Password": ""
        }
      }
    }
  },
  "ConnectionStrings": {
    "DefaultConnection": "Data Source=C:\\SmartCashBackEvo\\data\\app.db",
    "RefundConnection": "Data Source=C:\\SmartCashBackEvo\\data\\RefundDB.db"
  }
}
```

После изменений:
```powershell
Restart-Service SmartCashBackEvo
```

---

## Первый запуск

### 1. Запустить сервис

```powershell
Start-Service SmartCashBackEvo

# Проверить статус
Get-Service SmartCashBackEvo
# Status должен быть: Running
```

### 2. Открыть приложение

```powershell
Start-Process "https://localhost:5001"
```

### 3. Создать первого пользователя

1. Нажмите **Register** (Регистрация)
2. Заполните форму:
   - **Email**: admin@example.com
   - **Password**: надежный пароль (минимум 6 символов)
   - **Confirm Password**: повторите пароль
3. Нажмите **Register**

### 4. Назначить роль администратора

Первому пользователю нужно вручную назначить роль Admin через БД:

```powershell
# Установить sqlite3 если нет (через scoop или chocolatey)
# scoop install sqlite
# choco install sqlite

cd C:\SmartCashBackEvo\data

# Открыть БД
sqlite3 app.db

# Найти ID пользователя
SELECT Id, Email FROM AspNetUsers;

# Найти ID роли Admin
SELECT Id, Name FROM AspNetRoles WHERE Name = 'Admin';

# Назначить роль (замените на реальные ID)
INSERT INTO AspNetUserRoles (UserId, RoleId)
VALUES ('user-id-here', 'admin-role-id-here');

# Выход
.quit
```

Или через PowerShell:
```powershell
# Скачать sqlite3.exe если нет
Invoke-WebRequest -Uri "https://www.sqlite.org/2024/sqlite-tools-win-x64-3450000.zip" -OutFile "C:\Temp\sqlite.zip"
Expand-Archive C:\Temp\sqlite.zip C:\Temp\sqlite

# Выполнить запросы
C:\Temp\sqlite\sqlite3.exe C:\SmartCashBackEvo\data\app.db "SELECT * FROM AspNetUsers;"
```

---

## Решение проблем

### PowerShell не разрешает выполнение скриптов

**Симптомы:**
```
.\install-service.ps1 : File cannot be loaded because running scripts is disabled on this system.
```

**Решение 1 (Автоматически):**
Просто запустите скрипт установки - он сам предложит изменить политику:
```powershell
.\install-service.ps1
```

**Решение 2 (Вручную):**
```powershell
# Установить политику RemoteSigned для текущего пользователя
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned -Scope CurrentUser

# Проверить
Get-ExecutionPolicy -List
```

**Решение 3 (Временно, для одного скрипта):**
```powershell
powershell.exe -ExecutionPolicy Bypass -File .\install-service.ps1
```

### Сервис не запускается

```powershell
# 1. Проверить логи
Get-EventLog -LogName Application -Source SmartCashBackEvo -Newest 20 | Format-List

# 2. Проверить файлы
Test-Path C:\SmartCashBackEvo\app\SmartCashBackEvo.exe

# 3. Проверить конфигурацию
Get-Content C:\SmartCashBackEvo\app\appsettings.Production.json

# 4. Проверить права
Get-Acl C:\SmartCashBackEvo\data
```

**Частые причины:**
- Порт занят другим приложением
- Неправильный путь к сертификату
- Нет прав на папку data
- Ошибка в appsettings.json

### Порт уже используется

```powershell
# Найти процесс на порту 5001
netstat -ano | findstr :5001

# Результат: TCP  0.0.0.0:5001  0.0.0.0:0  LISTENING  1234
# PID в последней колонке (1234)

# Посмотреть что это за процесс
Get-Process -Id 1234

# Остановить если нужно
Stop-Process -Id 1234 -Force

# Или изменить порт
.\configure-ru.ps1
```

### Ошибки SSL/сертификата

```powershell
# 1. Проверить наличие сертификата
Test-Path C:\SmartCashBackEvo\certificate.pfx

# 2. Проверить путь в конфигурации
Get-Content C:\SmartCashBackEvo\app\appsettings.Production.json | Select-String -Pattern "Certificate"

# 3. Пересоздать сертификат
.\setup-ssl-ru.ps1

# 4. Перезапустить сервис
Restart-Service SmartCashBackEvo
```

### Нет доступа из сети

```powershell
# 1. Проверить файрвол
Get-NetFirewallRule -DisplayName "SmartCashBackEvo*"

# 2. Создать правила вручную если нет
New-NetFirewallRule -DisplayName "SmartCashBackEvo HTTPS" `
    -Direction Inbound `
    -Protocol TCP `
    -LocalPort 5001 `
    -Action Allow `
    -Profile Any

# 3. Проверить что сервис слушает на всех интерфейсах
netstat -an | findstr :5001
# Должно быть: 0.0.0.0:5001 или [::]:5001
```

### База данных заблокирована

```powershell
# Остановить сервис
Stop-Service SmartCashBackEvo

# Подождать
Start-Sleep -Seconds 5

# Убедиться что нет процессов
Get-Process | Where-Object {$_.Path -like "*SmartCashBackEvo*"}

# Запустить снова
Start-Service SmartCashBackEvo
```

### Просмотр подробных логов

```powershell
# Event Viewer
eventvwr.msc

# Перейти:
# Windows Logs > Application
# Правой кнопкой > Filter Current Log
# Event sources: SmartCashBackEvo

# Или через PowerShell
Get-EventLog -LogName Application -Source SmartCashBackEvo -Newest 50 |
    Format-Table TimeGenerated, EntryType, Message -AutoSize -Wrap
```

---

## Обновление

### Шаг 1: Подготовка

```powershell
# Остановить сервис
Stop-Service SmartCashBackEvo

# Создать резервную копию
$date = Get-Date -Format "yyyyMMdd_HHmmss"
$backup = "C:\Backups\SmartCashBackEvo_$date"
New-Item -ItemType Directory -Path $backup -Force

# Скопировать данные
Copy-Item "C:\SmartCashBackEvo\data" "$backup\data" -Recurse
Copy-Item "C:\SmartCashBackEvo\app\appsettings.Production.json" "$backup\"
Copy-Item "C:\SmartCashBackEvo\certificate.pfx" "$backup\" -ErrorAction SilentlyContinue

Write-Host "Бэкап создан: $backup"
```

### Шаг 2: Установка новой версии

```powershell
# Распаковать новую версию
Expand-Archive -Path "C:\Temp\SmartCashBackEvo_Distribution_NEW.zip" -DestinationPath "C:\Temp\New\" -Force

# Удалить старые файлы приложения (кроме appsettings)
Remove-Item "C:\SmartCashBackEvo\app\*" -Exclude "appsettings.Production.json" -Recurse -Force

# Скопировать новые файлы
Copy-Item "C:\Temp\New\Distribution\app\*" "C:\SmartCashBackEvo\app\" -Recurse -Force

# Восстановить конфигурацию
Copy-Item "$backup\appsettings.Production.json" "C:\SmartCashBackEvo\app\" -Force
```

### Шаг 3: Проверка и запуск

```powershell
# Проверить файлы
Test-Path "C:\SmartCashBackEvo\app\SmartCashBackEvo.exe"

# Запустить сервис
Start-Service SmartCashBackEvo

# Проверить статус
Get-Service SmartCashBackEvo

# Проверить работу
Invoke-WebRequest https://localhost:5001/health

# Проверить логи
Get-EventLog -LogName Application -Source SmartCashBackEvo -Newest 10
```

---

## Удаление

### С сохранением данных

```powershell
cd C:\SmartCashBackEvo\Deployment

.\uninstall-service-ru.ps1

# На вопрос "Удалить файлы приложения?" → n
# Данные останутся в C:\SmartCashBackEvo\data\
```

### Полное удаление

```powershell
.\uninstall-service-ru.ps1 -RemoveData -Force
```

### Ручное удаление

```powershell
# 1. Остановить сервис
Stop-Service SmartCashBackEvo -Force

# 2. Удалить сервис
sc.exe delete SmartCashBackEvo

# 3. Удалить файрвол
Remove-NetFirewallRule -DisplayName "SmartCashBackEvo*"

# 4. Удалить файлы
Remove-Item "C:\SmartCashBackEvo" -Recurse -Force

# 5. Удалить сертификат из Trusted Root (если самоподписанный)
# certlm.msc → Trusted Root Certification Authorities → Certificates
# Найти и удалить сертификат для localhost
```

---

## Резервное копирование

### Автоматический бэкап

```powershell
# Скрипт для планировщика задач
$backup = "C:\Backups\SmartCashBackEvo_$(Get-Date -Format 'yyyyMMdd_HHmmss')"
New-Item -ItemType Directory -Path $backup -Force

Stop-Service SmartCashBackEvo
Copy-Item "C:\SmartCashBackEvo\data\*.db" $backup
Copy-Item "C:\SmartCashBackEvo\app\appsettings.Production.json" $backup
Start-Service SmartCashBackEvo

# Удалить старые бэкапы (старше 30 дней)
Get-ChildItem "C:\Backups\SmartCashBackEvo_*" |
    Where-Object {$_.LastWriteTime -lt (Get-Date).AddDays(-30)} |
    Remove-Item -Recurse -Force
```

### Восстановление

```powershell
# Остановить сервис
Stop-Service SmartCashBackEvo

# Восстановить из бэкапа
$backupPath = "C:\Backups\SmartCashBackEvo_20250112_153000"
Copy-Item "$backupPath\*.db" "C:\SmartCashBackEvo\data\" -Force
Copy-Item "$backupPath\appsettings.Production.json" "C:\SmartCashBackEvo\app\" -Force

# Запустить сервис
Start-Service SmartCashBackEvo
```

---

## Дополнительные настройки

### Работа за reverse proxy (nginx, IIS)

```json
{
  "ClientUrl": "https://your-domain.com",
  "Kestrel": {
    "Endpoints": {
      "Http": {
        "Url": "http://localhost:5000"
      }
    }
  }
}
```

HTTPS обрабатывает прокси, Kestrel работает по HTTP.

### Автозапуск

Сервис уже настроен на автозапуск. Проверка:

```powershell
Get-Service SmartCashBackEvo | Select-Object Name, StartType
# StartType должен быть: Automatic
```

Изменить:
```powershell
Set-Service SmartCashBackEvo -StartupType Automatic
```

---

## Мониторинг

### Проверка здоровья

```powershell
# Простая проверка
Invoke-WebRequest https://localhost:5001/health

# С деталями
(Invoke-WebRequest https://localhost:5001/health).Content | ConvertFrom-Json
```

### Performance Monitor

```powershell
# Память
Get-Process SmartCashBackEvo | Select-Object `
    Name,
    @{Name="Memory (MB)"; Expression={$_.WorkingSet64 / 1MB}},
    @{Name="Private (MB)"; Expression={$_.PrivateMemorySize64 / 1MB}}

# CPU
Get-Counter "\Process(SmartCashBackEvo)\% Processor Time" -SampleInterval 2 -MaxSamples 5
```

---

## Контакты и поддержка

При возникновении проблем подготовьте:

```powershell
# Информация о системе
systeminfo | findstr /B /C:"OS"

# Версия PowerShell
$PSVersionTable.PSVersion

# Статус сервиса
Get-Service SmartCashBackEvo | Format-List *

# Логи
Get-EventLog -LogName Application -Source SmartCashBackEvo -Newest 20

# Порты
netstat -ano | findstr :5001

# Конфигурация (удалите пароли!)
Get-Content C:\SmartCashBackEvo\app\appsettings.Production.json
```

---

**Версия**: 1.0
**Дата**: 2025
**Платформа**: Windows Server 2016+
