# Автоматическая миграция базы данных

## Что произошло

Начиная с этой версии, приложение использует **единую базу данных** (`app.db`) для всех операций.

Ранее использовались две строки подключения:
- `DefaultConnection` - для Identity и системы отчетов
- `RefundConnection` - для данных возвратов, терминалов и групп

## Автоматическая миграция при запуске

При запуске приложения автоматически выполняется проверка:

1. **Если обе строки подключения указывают на одну БД** - ничего не происходит
2. **Если `RefundConnection` отсутствует** - ничего не происходит
3. **Если обе строки указывают на разные БД** - выполняется миграция:
   - Все данные из `RefundConnection` копируются в `DefaultConnection`
   - Старая строка `RefundConnection` удаляется из `appsettings.json`
   - Старый файл базы данных удаляется (создается резервная копия с суффиксом `.backup_<дата>`)

## Мигрируемые таблицы

- **Groups** - группы терминалов
- **Terminals** - терминалы
- **Refund** - возвраты
- **RefundOps** - история операций с возвратами
- **Cards** - карты

## Резервное копирование

Перед удалением старой базы данных автоматически создается резервная копия:
```
RefundDB.db → RefundDB.db.backup_ГГГГММДД_ЧЧММСС
```

## Логирование

Все этапы миграции логируются с уровнем `Information`. В логах вы увидите:
- Пути к обеим базам данных
- Количество мигрированных записей для каждой таблицы
- Результаты обновления конфигурации
- Результаты удаления старой БД

## Откат при необходимости

Если что-то пошло не так, вы можете:
1. Остановить приложение
2. Восстановить файл БД из резервной копии
3. Вручную отредактировать `appsettings.json`, добавив `RefundConnection`
4. Перезапустить приложение

## Изменения в коде

- `RefundDbRepository` теперь использует `DefaultConnection` вместо `RefundConnection`
- `ReportsController.GetGroups()` теперь читает из той же БД, что и остальные контроллеры
- Все данные теперь находятся в одной базе данных

## Преимущества единой БД

✅ Нет проблем с синхронизацией данных между двумя БД
✅ Упрощенное резервное копирование (один файл вместо двух)
✅ Отчеты всегда видят актуальные данные
✅ Упрощенная конфигурация

## Для разработчиков

Сервис миграции реализован в классе `DatabaseMigrationService` и вызывается в `Program.cs` при старте приложения, **до** применения EF Core миграций.

Код миграции автоматически обрабатывает:
- Разные форматы connection string (DataSource, Data Source, Filename)
- Относительные и абсолютные пути
- Docker пути вида `/app/data/...`
- Отсутствие файлов БД
