# SmartCashBackEvo - Windows Service

Система управления возвратами SmartCashBackEvo в виде Windows Service.

## 🚀 Быстрый старт

```powershell
# Запустите PowerShell от имени Администратора
cd Deployment

# Установка сервиса
.\install-service-ru.ps1 -StartService

# Настройка SSL
.\setup-ssl-ru.ps1

# Откройте браузер
Start-Process "https://localhost:5001"
```

## 📁 Содержимое пакета

```
Distribution/
├── app/                        # Приложение
├── data/                       # Папка для БД (создается при установке)
├── Deployment/                 # Скрипты установки
│   ├── install-service-ru.ps1
│   ├── setup-ssl-ru.ps1
│   ├── configure-ru.ps1
│   └── uninstall-service-ru.ps1
├── INSTALL-RU.md              # Подробная инструкция
└── README-RU.md               # Этот файл
```

## 📋 Скрипты

| Скрипт | Описание |
|--------|----------|
| `install-service-ru.ps1` | Установка Windows Service |
| `setup-ssl-ru.ps1` | Настройка SSL сертификата |
| `configure-ru.ps1` | Изменение конфигурации |
| `uninstall-service-ru.ps1` | Удаление сервиса |

## 🔐 SSL сертификат

При выполнении `setup-ssl-ru.ps1` доступны 3 варианта:

### 1. Автогенерация (рекомендуется) ⭐

```powershell
.\setup-ssl-ru.ps1
# Выбрать: 1
```

- Создается самоподписанный сертификат
- Автоматически добавляется в доверенные
- Срок действия: 10 лет
- Работает сразу

### 2. Свой сертификат

```powershell
.\setup-ssl-ru.ps1
# Выбрать: 2
# Указать путь к .pfx файлу
```

### 3. Без SSL (только HTTP)

```powershell
.\setup-ssl-ru.ps1
# Выбрать: 3
```

⚠️ Не рекомендуется для продакшена!

## 🎯 Управление сервисом

```powershell
# Запустить
Start-Service SmartCashBackEvo

# Остановить
Stop-Service SmartCashBackEvo

# Перезапустить
Restart-Service SmartCashBackEvo

# Статус
Get-Service SmartCashBackEvo

# Подробная информация
Get-Service SmartCashBackEvo | Format-List *
```

## ⚙️ Конфигурация

### Через интерактивное меню:

```powershell
.\configure-ru.ps1
```

Доступно:
1. Изменение портов HTTP/HTTPS
2. Изменение URL клиента
3. Настройка уровня логирования
4. Просмотр конфигурации
5. Ручное редактирование JSON

### Параметры установки:

```powershell
.\install-service-ru.ps1 `
    -InstallPath "C:\SmartCashBackEvo" `
    -ServiceName "SmartCashBackEvo" `
    -HttpPort 5000 `
    -HttpsPort 5001 `
    -StartService
```

## 📂 Файловая структура после установки

```
C:\SmartCashBackEvo\
├── app\                              # Приложение
│   ├── SmartCashBackEvo.exe
│   ├── appsettings.Production.json
│   └── wwwroot\
├── data\                             # Базы данных
│   ├── app.db
│   └── RefundDB.db
├── logs\                             # Логи
└── certificate.pfx                   # SSL сертификат
```

## 🔍 Проверка работы

```powershell
# 1. Проверить статус сервиса
Get-Service SmartCashBackEvo

# 2. Проверить здоровье
Invoke-WebRequest https://localhost:5001/health

# 3. Открыть в браузере
Start-Process "https://localhost:5001"

# 4. Проверить логи
Get-EventLog -LogName Application -Source SmartCashBackEvo -Newest 20
```

## 🐛 Решение проблем

### Сервис не запускается

```powershell
# Проверить логи
Get-EventLog -LogName Application -Source SmartCashBackEvo -Newest 20

# Проверить порты
netstat -ano | findstr :5001

# Изменить порт
.\configure-ru.ps1
```

### Порт занят

```powershell
# Найти процесс
netstat -ano | findstr :5001

# Остановить (PID из последней колонки)
Stop-Process -Id [PID] -Force

# Или изменить порт
.\configure-ru.ps1
```

### Проблемы с SSL

```powershell
# Пересоздать сертификат
.\setup-ssl-ru.ps1

# Перезапустить сервис
Restart-Service SmartCashBackEvo
```

### Нет доступа из сети

```powershell
# Проверить файрвол
Get-NetFirewallRule -DisplayName "SmartCashBackEvo*"

# Создать правила вручную
New-NetFirewallRule -DisplayName "SmartCashBackEvo HTTPS" `
    -Direction Inbound `
    -Protocol TCP `
    -LocalPort 5001 `
    -Action Allow `
    -Profile Any
```

## 💾 Резервное копирование

```powershell
# Создать бэкап
$backup = "C:\Backups\SmartCashBackEvo_$(Get-Date -Format 'yyyyMMdd_HHmmss')"
New-Item -ItemType Directory -Path $backup

# Остановить сервис
Stop-Service SmartCashBackEvo

# Скопировать данные
Copy-Item "C:\SmartCashBackEvo\data\*.db" $backup
Copy-Item "C:\SmartCashBackEvo\app\appsettings.Production.json" $backup
Copy-Item "C:\SmartCashBackEvo\certificate.pfx" $backup

# Запустить сервис
Start-Service SmartCashBackEvo
```

## 🔄 Обновление приложения

```powershell
# Остановить сервис
Stop-Service SmartCashBackEvo

# Резервная копия данных и конфигурации
$date = Get-Date -Format "yyyyMMdd_HHmmss"
Copy-Item "C:\SmartCashBackEvo\data" "C:\Backup\data_$date" -Recurse
Copy-Item "C:\SmartCashBackEvo\app\appsettings.Production.json" "C:\Backup\appsettings_$date.json"

# Заменить файлы приложения (из новой версии)
Remove-Item "C:\SmartCashBackEvo\app\*" -Recurse -Force
Copy-Item ".\app\*" "C:\SmartCashBackEvo\app\" -Recurse -Force

# Восстановить конфигурацию
Copy-Item "C:\Backup\appsettings_$date.json" "C:\SmartCashBackEvo\app\appsettings.Production.json"

# Запустить сервис
Start-Service SmartCashBackEvo
```

## 🗑️ Удаление

```powershell
cd C:\SmartCashBackEvo\Deployment

# Удалить с возможностью сохранить данные
.\uninstall-service-ru.ps1

# Или полное удаление
.\uninstall-service-ru.ps1 -RemoveData -Force
```

## 📊 Мониторинг

### Просмотр логов

```powershell
# Последние 20 записей
Get-EventLog -LogName Application -Source SmartCashBackEvo -Newest 20 | Format-Table TimeGenerated, Message -AutoSize

# Event Viewer
eventvwr.msc
# Windows Logs > Application > Фильтр: SmartCashBackEvo
```

### Производительность

```powershell
# Память
Get-Process SmartCashBackEvo | Select-Object Name, WorkingSet, PrivateMemorySize

# CPU
Get-Counter "\Process(SmartCashBackEvo)\% Processor Time"
```

## 📡 Требования

- Windows Server 2016+ или Windows 10/11 Pro
- 2+ GB RAM
- 500 MB свободного места
- Порты 5000 (HTTP), 5001 (HTTPS)
- Права администратора

## 🌐 Доступ

- **Локально**: https://localhost:5001
- **Из сети**: https://IP-адрес-сервера:5001
- **Здоровье**: https://localhost:5001/health

## 📞 Поддержка

При проблемах подготовьте:
1. Логи: `Get-EventLog -LogName Application -Source SmartCashBackEvo -Newest 20`
2. Статус: `Get-Service SmartCashBackEvo | Format-List *`
3. Версия Windows: `systeminfo | findstr /B /C:"OS"`
4. Конфигурация (без паролей!)

## 📖 Дополнительная документация

См. **INSTALL-RU.md** для подробных инструкций по:
- Установке
- Настройке SSL
- Конфигурации
- Решению проблем
- Первому запуску

---

**Версия**: 1.0
**Дата**: 2025
**.NET**: 8.0
**Платформа**: Windows Server 2016+
